/*
 * SPI.c
 *
 *  Created on: Jan 21, 2020
 *      Author: a0222913
 */
#include <msp430.h>
#include <TLC6983DMA.h>



void spiInitial()
{

    UCB0CTL1 |= UCSWRST; //USCI rest software
    //UCB0CTL0 |= UCCKPH + UCMSB + UCMST;//UCCKPH = 1, UCCKPL = 0;
    UCB0CTL0 |= UCCKPL + UCMSB + UCMST;//UCCKPH = 0, UCCKPL = 1;
    //UCB0CTL0 |= UCMSB + UCMST;//UCCKPH = 0, UCCKPL = 0;
    //UCB0CTL0 |= UCCKPH + UCCKPL + UCMSB + UCMST;//UCCKPH = 1, UCCKPL = 1;
                                // MSB first, master mode
    UCB0CTL1 |= UCSSEL__SMCLK ; //UCLK = SMCLK = 20MHz
    //UCB0BR0 = 2;
#ifdef _LOW_FREQUENCY
    UCB0BR0 = 4;//fBitClock = 20/4 = 5MHz
#else
    UCB0BR0 = 2;//fBitClock = 20/2 = 10MHz
#endif
    UCB0BR1 = 0;
    P3DIR |= BIT0 + BIT2; //P3.0 -> SIMO, P3.2 -> SPICLK;
    P3DIR &= ~ BIT1; //P3.1 -> SOMI;
    P3SEL |= BIT0 + BIT1 + BIT2;
    UCB0CTL0 &= ~UC7BIT; //8-bit character length
    UCB0CTL1 &= ~UCSWRST; //USCI rest released for operation
}

